/*
 * Decompiled with CFR 0.152.
 */
package com.belenus.dataconnect;

import com.belenus.dataconnect.Row;
import com.belenus.dataconnect.RowContainer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Vector;
import org.apache.log4j.Logger;

public abstract class AbstractRowContainer
implements RowContainer {
    private static final Logger logger = Logger.getLogger((Class)(class$com$belenus$dataconnect$AbstractRowContainer == null ? (class$com$belenus$dataconnect$AbstractRowContainer = AbstractRowContainer.class$("com.belenus.dataconnect.AbstractRowContainer")) : class$com$belenus$dataconnect$AbstractRowContainer));
    protected static final int MAX_ROWS = 100000;
    protected Vector m_rows = new Vector();
    protected int m_currentRowIndex = -1;
    protected Row m_surroundingRow;
    static /* synthetic */ Class class$com$belenus$dataconnect$AbstractRowContainer;

    protected abstract void nextResult();

    protected abstract boolean isFinished();

    public synchronized Row previousRow() {
        if (this.m_currentRowIndex > 0) {
            --this.m_currentRowIndex;
        } else {
            this.m_currentRowIndex = -1;
            throw new IllegalStateException("No previous rows available in RowContainer");
        }
        return (Row)this.m_rows.get(this.m_currentRowIndex);
    }

    public synchronized Row currentRow() {
        if (this.m_currentRowIndex < 0 || this.m_currentRowIndex > this.m_rows.size() - 1) {
            throw new IllegalStateException("Out of range");
        }
        return (Row)this.m_rows.get(this.m_currentRowIndex);
    }

    public synchronized Row nextRow() {
        ++this.m_currentRowIndex;
        if (this.m_currentRowIndex >= this.m_rows.size()) {
            this.nextResult();
            if (this.m_currentRowIndex >= this.m_rows.size()) {
                this.m_currentRowIndex = this.m_rows.size();
                throw new IllegalStateException("No next rows available in RowContainer");
            }
        }
        return (Row)this.m_rows.get(this.m_currentRowIndex);
    }

    public synchronized void resetPosition() {
        this.m_currentRowIndex = -1;
    }

    public synchronized int getPosition() {
        return this.m_currentRowIndex;
    }

    public synchronized void setPosition(int position) {
        if (position == -1) {
            this.resetPosition();
        } else if (position >= 0 && position < this.m_rows.size()) {
            this.m_currentRowIndex = position;
        } else if (position >= 0 && !this.isFinished()) {
            this.m_currentRowIndex = this.m_rows.size() - 1;
            while (this.m_currentRowIndex < position) {
                this.nextRow();
            }
        } else {
            throw new IllegalArgumentException("Position in RowContainer out of range");
        }
    }

    public synchronized void setToEnd() {
        while (!this.isFinished()) {
            this.nextResult();
        }
        this.m_currentRowIndex = this.m_rows.size() - 1;
    }

    public synchronized void setToStart() {
        if (0 < this.m_rows.size()) {
            this.m_currentRowIndex = 0;
        }
    }

    public synchronized boolean hasPrevious() {
        return this.m_currentRowIndex > 0;
    }

    public synchronized boolean hasNext() {
        if (this.m_currentRowIndex < this.m_rows.size() - 1) {
            return true;
        }
        if (!this.isFinished()) {
            this.nextResult();
        }
        return this.m_currentRowIndex < this.m_rows.size() - 1;
    }

    public synchronized boolean isEmpty() {
        return this.m_rows.size() <= 0;
    }

    public void remove() {
        this.m_rows.remove(this.m_currentRowIndex);
    }

    public void insert(Row row) {
        if (this != row.getRowContainer() || row.getFields().length != this.getColumnNames().length) {
            throw new IllegalArgumentException("Row does not match RowContainer");
        }
        this.m_rows.add(this.m_currentRowIndex, row);
    }

    public void destroy() {
        for (int rowsIndex = 0; rowsIndex < this.m_rows.size(); ++rowsIndex) {
            Row row = (Row)this.m_rows.get(rowsIndex);
            if (row == null || row.m_containingRowContainer == null) continue;
            row.m_containingRowContainer.destroy();
        }
    }

    public void finalize() throws Throwable {
        this.destroy();
        super.finalize();
    }

    public String[] getFieldNamesByMeaning(String meaning) {
        ArrayList<String> foundFieldNames = new ArrayList<String>();
        String meaning_ = meaning + "_";
        String[] fieldNames = this.getColumnNames();
        for (int fieldNamesIndex = 0; fieldNamesIndex < fieldNames.length; ++fieldNamesIndex) {
            String fieldName = fieldNames[fieldNamesIndex];
            if (!fieldName.startsWith(meaning_)) continue;
            foundFieldNames.add(fieldName);
        }
        return foundFieldNames.toArray(new String[foundFieldNames.size()]);
    }

    public String[] getDescriptionsByMeaning(String meaning) {
        HashSet<String> foundFieldNames = new HashSet<String>();
        String meaning_ = meaning + "_";
        String[] fieldNames = this.getColumnNames();
        for (int fieldNamesIndex = 0; fieldNamesIndex < fieldNames.length; ++fieldNamesIndex) {
            int pos2;
            int pos1;
            String meaning_description;
            String fieldName = fieldNames[fieldNamesIndex];
            if (!fieldName.startsWith(meaning_) || foundFieldNames.contains(meaning_description = (pos1 = fieldName.indexOf(95)) < (pos2 = fieldName.lastIndexOf(95)) ? fieldName.substring(0, pos2) : fieldName)) continue;
            foundFieldNames.add(meaning_description);
        }
        return foundFieldNames.toArray(new String[foundFieldNames.size()]);
    }

    public String nameOfField(String fieldName) {
        int pos1 = fieldName.indexOf(95);
        int pos2 = fieldName.lastIndexOf(95);
        if (pos1 == -1) {
            return fieldName;
        }
        if (pos1 < pos2) {
            return fieldName.substring(pos1 + 1, pos2);
        }
        return fieldName.substring(pos1 + 1);
    }

    public String[] getFieldNamesByDescription(String meaning_description) {
        ArrayList<String> foundFieldNames = new ArrayList<String>();
        String meaning_description_ = meaning_description + "_";
        String[] fieldNames = this.getColumnNames();
        for (int fieldNamesIndex = 0; fieldNamesIndex < fieldNames.length; ++fieldNamesIndex) {
            String fieldName = fieldNames[fieldNamesIndex];
            if (!fieldName.equals(meaning_description) && !fieldName.startsWith(meaning_description_)) continue;
            foundFieldNames.add(fieldName);
        }
        return foundFieldNames.toArray(new String[foundFieldNames.size()]);
    }

    public Locale getLocaleFromFieldName(String fieldName) {
        int pos2;
        int pos1 = fieldName.indexOf(95);
        if (pos1 < (pos2 = fieldName.lastIndexOf(95))) {
            String localeIdentifier = fieldName.substring(pos2 + 1);
            String language = localeIdentifier.substring(0, 2).toLowerCase();
            if (localeIdentifier.length() == 2) {
                return new Locale(language);
            }
            if (localeIdentifier.length() == 4) {
                String country = localeIdentifier.substring(2, 4).toUpperCase();
                return new Locale(language, country);
            }
            return null;
        }
        return null;
    }

    public void setSurroundingRow(Row row) {
        this.m_surroundingRow = row;
    }

    public Row getSurroundingRow() {
        return this.m_surroundingRow;
    }

    public int resultCount() {
        while (!this.isFinished()) {
            this.nextResult();
        }
        return this.m_rows.size();
    }

    public ArrayList[] getMappedFieldNamesByMeaning(String meaning) {
        String[] fieldNamesByMeaning = this.getFieldNamesByMeaning(meaning);
        ArrayList<String> mappings = new ArrayList<String>();
        ArrayList listOfFieldNames = new ArrayList();
        for (int fieldNamesByMeaningIndex = 0; fieldNamesByMeaningIndex < fieldNamesByMeaning.length; ++fieldNamesByMeaningIndex) {
            String fieldName = fieldNamesByMeaning[fieldNamesByMeaningIndex];
            String mapping = this.getGeneralMapped(fieldName);
            int mappingsIndex = mappings.indexOf(mapping);
            if (mappingsIndex == -1) {
                mappings.add(mapping);
                ArrayList<String> fields = new ArrayList<String>();
                fields.add(fieldName);
                ArrayList<ArrayList<String>> umbrella = new ArrayList<ArrayList<String>>();
                umbrella.add(fields);
                listOfFieldNames.add(umbrella);
                continue;
            }
            ArrayList umbrella = (ArrayList)listOfFieldNames.get(mappingsIndex);
            String nameOfField = this.nameOfField(fieldName);
            boolean allreadyInUmbrella = false;
            for (int umbrellaIndex = 0; umbrellaIndex < umbrella.size(); ++umbrellaIndex) {
                ArrayList fieldNames = (ArrayList)umbrella.get(umbrellaIndex);
                String nameOfUmbrella = this.nameOfField((String)fieldNames.get(0));
                if (!nameOfField.equals(nameOfUmbrella)) continue;
                fieldNames.add(fieldName);
                allreadyInUmbrella = true;
                break;
            }
            if (allreadyInUmbrella) continue;
            ArrayList<String> fields = new ArrayList<String>();
            fields.add(fieldName);
            umbrella.add(fields);
        }
        return new ArrayList[]{mappings, listOfFieldNames};
    }

    private String getGeneralMapped(String fieldName) {
        String mapped = "";
        String nameOfField = this.nameOfField(fieldName);
        for (int nameOfFieldIndex = 0; nameOfFieldIndex < nameOfField.length(); ++nameOfFieldIndex) {
            char ch = nameOfField.charAt(nameOfFieldIndex);
            if (ch >= '0' && ch <= '9') {
                return mapped;
            }
            mapped = nameOfField.substring(0, nameOfFieldIndex + 1);
        }
        return nameOfField;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

